/**********************************************************************************************
* Device      : AD18F08
* Author      : fengxuanmian
* Version     : V0.0.1
* Date        : 2023.5.5
* Description :  配置字中选择_IDIS_OFF_2L,当IO的模拟通道打开时，读取IO的数据始终为0
*                配置字中选择_IDIS_ON_2L, 当IO的模拟通道打开时，也可以正常读取IO的值
*                当选择_IDIS_OFF_2L时，无论如何给PA口高电平，PB4每10ms都会翻转
*                当选择_IDIS_ON_2L时，给PA1口加入高电平，则PB4不会翻转，取消PA1口的高电压后，PB4开始翻转
*                现象：配置读取PA管脚的值，读取为0时，PB4口开始翻转；读取不为0时，PB4口无翻转
***********************************************************************************************/

#include "AD18F08.h"

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG口不能做普通IO用）
* _LVREN_OFF         :  禁止LVR
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位
*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_ON_2L  & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                      );
//---------配置字 IDIS 可选--------------
//_IDIS_OFF_2L        模拟IO打开，读取IO数据始终为0。
//_IDIS_ON_2L         模拟IO打开，能正常读取IO输入
//------------------------注：模拟IO关闭，IDIS位对读取IO输入无影响。

//==============================================================================================
// ----Function: 主程序
// --Parameters: None
// -----Returns: None
//---------Note:
//==============================================================================================
void main(void)
{
    unsigned char i;

	TRISA = 0x3f;       //所有PA口均设置为输入
	PA1PD = 0;          //打开PA1下拉
	ANASEL0 = 0x3f;     //打开所有PA口模拟通道
    TRISB4 = 0;         //PB4口设置为输出

    do
    {i = PINA & 0x3f;}
    while(i!=0x00);       //若读管脚得到的值为0，跳出循环后执行PB4翻转。若读的值不为0，继续循环

    while(1)
    {
		__delay_ms(10);                //10ms延时后翻转PB4
		PB4=~PB4;
	}
}

//高优先级中断服务函数
void interrupt ISR_h (void)
{

}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{

}

